/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.sysutils.OperatingSystem;
import filenet.vw.sysutils.ProcessResult;
import filenet.vw.sysutils.ProcessStreamReader;
import java.io.OutputStream;

public class ProcessLauncher {
    private static String m_className = ProcessLauncher.class.getName();
    private static Logger logger = Logger.getLogger("filenet.vw.sysutils");

    public static String _get_FILE_DATE() {
        return "$Date:   14 Oct 2008 10:15:32  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    private ProcessLauncher() {
    }

    public static ProcessResult exec(String command, String inputData, boolean wait) throws Exception {
        logger.fine(m_className, "exec", "Executing: " + command);
        Process process = Runtime.getRuntime().exec(command);
        if (wait) {
            return ProcessLauncher.getResult(process, inputData);
        }
        ProcessLauncher.closeStreams(process);
        return null;
    }

    public static ProcessResult exec(String command, boolean wait) throws Exception {
        return ProcessLauncher.exec(command, null, wait);
    }

    public static ProcessResult exec(String[] cmdArray, String inputData, boolean wait) throws Exception {
        String method = "exec";
        logger.fine(m_className, method, "Executing: ");
        for (int i = 0; i < cmdArray.length; ++i) {
            if (OperatingSystem.isWindows() && (cmdArray[i] == null || cmdArray[i].equals(""))) {
                cmdArray[i] = "\"\"";
            }
            logger.fine(m_className, method, cmdArray[i]);
        }
        Process process = Runtime.getRuntime().exec(cmdArray);
        if (wait) {
            return ProcessLauncher.getResult(process, inputData);
        }
        ProcessLauncher.closeStreams(process);
        return null;
    }

    public static ProcessResult exec(String[] cmdArray, boolean wait) throws Exception {
        return ProcessLauncher.exec(cmdArray, null, wait);
    }

    private static void closeStreams(Process p) {
        String method = "closeStreams";
        try {
            p.getInputStream().close();
        }
        catch (Exception e) {
            logger.log(Level.FINE, m_className, method, "", e);
        }
        try {
            p.getErrorStream().close();
        }
        catch (Exception e) {
            logger.log(Level.FINE, m_className, method, "", e);
        }
    }

    private static ProcessResult getResult(Process process, String inputData) throws Exception {
        String method = "getResult";
        StringBuffer outputBuffer = new StringBuffer();
        StringBuffer errorBuffer = new StringBuffer();
        ProcessStreamReader outputReader = null;
        ProcessStreamReader errorReader = null;
        outputReader = new ProcessStreamReader(process.getInputStream(), outputBuffer);
        outputReader.start();
        errorReader = new ProcessStreamReader(process.getErrorStream(), errorBuffer);
        errorReader.start();
        if (inputData != null) {
            OutputStream oStream = process.getOutputStream();
            oStream.write(inputData.getBytes());
            oStream.flush();
            oStream.close();
        }
        logger.fine(m_className, method, "Waiting for process to exit.");
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            outputReader.join(1000L);
            errorReader.join(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ProcessResult result = new ProcessResult(process.exitValue(), outputBuffer.toString(), errorBuffer.toString());
        logger.fine(m_className, method, "Process exit value: " + result.exitValue());
        logger.fine(m_className, method, "Process output stream: " + result.getOutput().trim());
        logger.fine(m_className, method, "Process error stream: " + result.getError().trim());
        return result;
    }
}

